
/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developers bulletin board at forum.melissadata.com.
********************************************************************************/

using System;
using MelissaData;

namespace mdAddrSample
{
    class Program
    {
        public static String the_license = "license here";
        public static String datafile_dir = "C:\\Program Files\\Melissa Data\\COM Objects\\Data Files";

        static void Main(string[] args)
        {
            mdAddr addrObj = new mdAddr();

		/********************** LICENSE STRINGS **********************
                  *     To unlock the full functionality of Address Object,      *
                *     	     Or to obtain a Demo License String          *
                * please call a sales representative at 1-800-MELISSA ext. 3 *
                *         (1-800-635-4772 x3) for a license string.          *
                    **************************************************************/	
            addrObj.SetLicenseString(the_license);

            addrObj.SetPathToUSFiles(datafile_dir);

            //add-ons
            //addrObj.SetPathToDPVDataFiles(datafile_dir);
            //addrObj.SetPathToLACSLinkDataFiles(datafile_dir);
            //addrObj.SetPathToRBDIFiles(datafile_dir);
            //addrObj.SetPathToCanadaFiles(datafile_dir);

            if (addrObj.InitializeDataFiles() != mdAddr.ProgramStatus.ErrorNone)
            {
                Console.WriteLine("Error initializing mdAddr: " + addrObj.GetInitializeErrorString());
                Console.ReadLine();
                return;
            }

            //Get information about the object:
            Console.WriteLine("Build Number: " + addrObj.GetBuildNumber());
            Console.WriteLine("Database Date: " + addrObj.GetDatabaseDate());
            Console.WriteLine("Database Expiration Date: " + addrObj.GetExpirationDate());

            bool proceed = true;
            while (proceed)
            {
                //Get Address and Verify
                Console.Write("Enter Address : ");
                String address = Console.ReadLine();
                Console.Write("Enter Address2 : ");
                String address2 = Console.ReadLine();
                Console.Write("Enter City : ");
                String city = Console.ReadLine();
                Console.Write("Enter State : ");
                String state = Console.ReadLine();
                Console.Write("Enter Zip : ");
                String zip = Console.ReadLine();

                addrObj.SetAddress(address);
                addrObj.SetAddress2(address2);
                addrObj.SetCity(city);
                addrObj.SetState(state);
                addrObj.SetZip(zip);

                if (addrObj.VerifyAddress())
                {
                    Console.WriteLine("Status Code: " + addrObj.GetStatusCode());
                    Console.WriteLine("Error Code: " + addrObj.GetErrorCode());
                    Console.WriteLine("Error String: " + addrObj.GetErrorString());
                    Console.WriteLine("Address: " + addrObj.GetAddress());
                    Console.WriteLine("Address2: " + addrObj.GetAddress2());
                    Console.WriteLine("Suite: " + addrObj.GetSuite());
                    Console.WriteLine("Private Mailbox: " + addrObj.GetPrivateMailbox());
                    Console.WriteLine("City: " + addrObj.GetCity());
                    Console.WriteLine("State: " + addrObj.GetState());
                    Console.WriteLine("Zip: " + addrObj.GetZip());
                    Console.WriteLine("Plus4: " + addrObj.GetPlus4());
                    Console.WriteLine("Carrier Route: " + addrObj.GetCarrierRoute());
                    Console.WriteLine("Delivery Point Code: " + addrObj.GetDeliveryPointCode());
                    Console.WriteLine("Delivery Point Check Digit: " + addrObj.GetDeliveryPointCheckDigit());
                }
                else
                {
                    Console.WriteLine("Status Code: " + addrObj.GetStatusCode());
                    Console.WriteLine("Error Code: " + addrObj.GetErrorCode());
                    Console.WriteLine("Error String: " + addrObj.GetErrorString());
                }

                Console.Write("Enter X to quit:");
                string quit = Console.ReadLine();
                if (quit.ToUpper().Trim() == "X")
                {
                    proceed = false;
                }
            }

            addrObj.Dispose();
            Console.ReadLine();
        }
    }
}
